<?php
// 📥 Получаем имя персонажа
$char_name = trim($_POST['char_name'] ?? '');

if (!$char_name) {
    http_response_code(400);
    exit("Missing char_name");
}

$file = __DIR__ . '/request.txt';

// 🔁 Проверяем, есть ли уже такой запрос
$lines = file_exists($file) ? file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
foreach ($lines as $line) {
    $entry = json_decode($line, true);
    if (isset($entry['char_name']) && $entry['char_name'] === $char_name) {
        exit("Already requested");
    }
}

// ✏️ Добавляем новый запрос
$newEntry = json_encode(['char_name' => $char_name, 'timestamp' => time()]);
file_put_contents($file, $newEntry . PHP_EOL, FILE_APPEND);
echo "Request added for $char_name";
