<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

$char = $_POST['char'] ?? '';
$file = $_POST['file'] ?? '';

if (!preg_match('/^[a-zA-Z0-9_-]+$/', $char)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid character name']);
    exit;
}

if (!preg_match('/^[a-zA-Z0-9_.-]+$/', $file)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid filename']);
    exit;
}

$folder = realpath(__DIR__);
$filepath = realpath($folder . '/' . $file);

if (!$filepath || strpos($filepath, $folder) !== 0) {
    http_response_code(400);
    echo json_encode(['error' => 'File not found or invalid path']);
    exit;
}

if (!file_exists($filepath)) {
    http_response_code(404);
    echo json_encode(['error' => 'File does not exist']);
    exit;
}

if (unlink($filepath)) {
    echo json_encode(['success' => true]);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to delete file']);
}
?>
