<?php
$target_dir = __DIR__ . "/screenshots/";
if (!file_exists($target_dir)) mkdir($target_dir, 0777, true);

// Сохраняем с уникальным именем
$filename = uniqid("screenshot_", true) . ".png";
$target_path = $target_dir . $filename;

// Получаем "сырые" данные
$data = file_get_contents("php://input");
if ($data === false || strlen($data) < 1000) { // минимальная длина для PNG
    http_response_code(400);
    echo json_encode(["success" => false, "error" => "Invalid or too small image data"]);
    exit;
}

// Пишем файл
file_put_contents($target_path, $data);

// Возвращаем имя файла
echo json_encode(["success" => true, "file" => basename($filename)]);
?>
