<?php
date_default_timezone_set('UTC');
header('Content-Type: application/json');

// Путь к файлу с сохранёнными адресами
$dataFile = __DIR__ . '/trc_addresses.json';

// Получаем данные из POST
$charname   = $_POST['charname']    ?? '';
$amount     = $_POST['amount']      ?? '';
$currency   = $_POST['currency']    ?? '';
$trcAddress = $_POST['trc_address'] ?? '';

// Простейшая валидация
if (empty($charname) || empty($amount) || empty($trcAddress) || empty($currency)) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing parameters']);
    exit;
}

if (!is_numeric($amount) || $amount <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid amount']);
    exit;
}

if (!preg_match('/^T[a-zA-Z0-9]{33,}$/', $trcAddress)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid TRC20 address']);
    exit;
}

$allowedCurrencies = ['WCoinC', 'WCoinP', 'GoblinPoint'];
if (!in_array($currency, $allowedCurrencies)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid currency']);
    exit;
}

// Загружаем текущие данные
$existingData = [];
if (file_exists($dataFile)) {
    $json = file_get_contents($dataFile);
    $existingData = json_decode($json, true);
    if (!is_array($existingData)) {
        $existingData = [];
    }
}

// Добавляем новую запись с временем
$existingData[] = [
    'charname'    => $charname,
    'amount'      => floatval($amount),
    'currency'    => $currency,
    'trc_address' => $trcAddress,
    'timestamp'   => date('Y-m-d H:i:s'),
];

// Сохраняем обратно в файл
if (file_put_contents($dataFile, json_encode($existingData, JSON_PRETTY_PRINT))) {
    echo json_encode(['success' => true, 'message' => 'TRC20 address saved']);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to save data']);
}
