<?php
require 'vendor/autoload.php';
$config = require __DIR__ . '/config.php';

// ✅ Устанавливаем ключ Stripe
\Stripe\Stripe::setApiKey($config['stripe_secret_key']);

// ✅ Получаем данные из POST
$name     = $_POST['charname'] ?? '';
$currency = $_POST['currency'] ?? 'WCoinC';
$amount   = (int)($_POST['amount'] ?? 0);

// ✅ Валидация
if ($name === '' || $amount <= 0) {
    echo json_encode(['error' => 'Invalid data']);
    http_response_code(400);
    exit;
}

// 💶 Получаем курс из config.php
$rates = $config['rates'];
$eurAmount = $amount * ($rates[$currency] ?? 0);

// 📉 Применяем скидки из config.php['discounts']
$discount = 0;
foreach (array_reverse($config['discounts'], true) as $threshold => $rate) {
    if ($eurAmount >= $threshold) {
        $discount = $rate;
        break;
    }
}

$finalAmount = round($eurAmount * (1 - $discount), 2);

// 📝 Логирование
file_put_contents("stripe-create.log", "[" . date("Y-m-d H:i:s") . "] $name | $currency x$amount | €$finalAmount\n", FILE_APPEND);

// ✅ Создание Checkout-сессии
try {
    $session = \Stripe\Checkout\Session::create([
        'payment_method_types' => ['card'],
        'line_items' => [[
            'price_data' => [
                'currency' => 'eur',
                'product_data' => [
                    'name' => "$currency x$amount ($name)"
                ],
                'unit_amount' => $finalAmount * 100, // евро → центы
            ],
            'quantity' => 1,
        ]],
        'mode' => 'payment',
        'success_url' => $config['success_url'],
        'cancel_url'  => $config['cancel_url'],
        'metadata' => [
            'charname' => $name,
            'currency' => $currency,
            'amount'   => $amount
        ]
    ]);

    echo json_encode([
        'checkout_url' => $session->url
    ]);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['error' => $e->getMessage()]);
}
